class W3EnergyDummy extends CProjectileTrajectory
{
	var fxEntity 						: CEntity;
	var comp 							: CEffectDummyComponent;
	var position 						: Vector;
	var position_0						: Vector;
	var position_1						: Vector;
	var outPosition						: Vector;
	var outNormal						: Vector;
	var position_init					: Vector;
	var i								: Int;
	var burn_ground						: CEntity;
	var temp							: string;
	var rotation 						: EulerAngles;
	var effect_name 					: name;
	var entities						: array<CGameplayEntity>;
	var entities_col					: array<CGameplayEntity>;
	var target 							: CActor;
	var targets 						: array<CActor>;
	var damage_action					: W3DamageAction;
	var damage_value					: float;
	var effect_entity					: CEntity;
	
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
	
		AddTimer('check_for_targets_energy_cone', 0.01, true );
	}
	
	
	timer function check_for_targets_energy_cone ( dt : float, optional id : int)
	{
		FindGameplayEntitiesInCone( entities, GetWorldPosition() + GetWorldForward() * 3, VecHeading( GetWorldForward() * -1 ), 180, 4, 100 );
		if ( entities.Size() >0 )
		{
			for( i = 0; i < entities.Size(); i += 1 )
			{
				if ( !entities_col.Contains( entities[i] ) && !entities[i].HasTag('spells_custom_projs') )
				{
					entities_col.PushBack( entities[i] );
					target = (CActor)entities[i];
					if ( target && target != thePlayer && GetAttitudeBetween( target, thePlayer ) == AIA_Hostile && target.IsAlive() )
					{
						damage_value = get_damage_value_for_cone_far( target, GetMagicVigil().get_magic_spellpower() );
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_Heavy,CPS_Undefined,false, false, true, false );
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetCanPlayHitParticle(false);
						damage_action.SetHitAnimationPlayType(EAHA_Default);
						
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * damage_value );
						
						effect_entity = target.CreateFXEntityAtPelvis( 'spells_energy_effects', true );
						effect_entity.PlayEffect( 'energy_hit_effect2' );
						effect_entity.DestroyAfter(5);
						
						if ( spells_can_dismember( target ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action );
						delete damage_action;
					}
				}
			}
		}
	}
	
	event OnRangeReached()
	{
		StopProjectile();
		RemoveTimer('check_for_targets_energy_cone');
	}
}

class W3MIgniGranade extends CProjectileTrajectory
{
	protected var collidedEntities2 : array<CGameplayEntity>;
	var dmg_action                  : W3DamageAction;
	var victimsand					: CNewNPC;	
	var entities,entities2,entities3: array< CGameplayEntity >;
	var i	 						: int;
	var lastCollisionFxPos 			: Vector;
	var spellpower 					: SAbilityAttributeValue;
	var damage						: Float;
	var effect_entity				: CEntity;
	var active 						: Bool;
	var victims						: array<CGameplayEntity>;
	var spellpower_final			: float;
	var comp						: CMeshComponent;
	var range						: float;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		comp = (CMeshComponent)this.GetComponentByClassName('CMeshComponent');
		comp.SetScale( Vector ( 0.f, 0.f, 0.f ) );
	}

	timer function play_eff(deltaTime : float, id : int) 
	{
		PlayEffect( 'fire_fx3' );
	}
	
    timer function destroy_fireentity_proj(deltaTime : float, id : int) 
	{
		SoundEvent("fx_fire_burning_body_strong_loop_end");
		SoundEvent("fx_fire_burning_strong_end");
		StopAllEffects();
		DestroyAfter(3);
	}
	
    timer function check_targets(deltaTime : float, id : int) 
	{
		entities2.Clear();
		FindGameplayEntitiesInRange( entities2, this, 0.2, 2, , FLAG_Attitude_Hostile+FLAG_OnlyAliveActors+FLAG_ExcludePlayer );
		if ( entities2.Size() > 0 ) 
		{
			to_destroy();
		}
	}
	
	event OnProjectileInit()
	{
		PlayEffect( 'fire_fx' );
		active = true;
		SoundEvent("fx_fire_burning_body_strong_loop");	
		SoundEvent("fx_fire_burning_body_strong_loop");	
		SoundEvent("fx_fire_burning_strong_begin");
		SoundEvent("fx_fire_burning_strong_begin");
		
		if ( HasTag('spells_from_sign') )
		{
			spellpower_final = GetMagicVigil().get_magic_spellpower();
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final + "HAS TAG" + (string)HasTag('spells_from_sign') );
		}
		else
		{
			spellpower_final = get_spellpower_spells( true );
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final );
		}
		
		range = 3;
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
	
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;

		
		if ( victim && victim.IsAlive() && !victims.Contains(victim) && victim != thePlayer )
		{
			theGame.GetSurfacePostFX().AddSurfacePostFXGroup(pos, 0.3f, 5, 1.f, 5.f, 1);
			
			to_destroy();
		}
		else
		if ( ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Static' ) || hitCollisionsGroups.Contains( 'Water' ) ) && active )
		{
			theGame.GetSurfacePostFX().AddSurfacePostFXGroup(pos, 0.3f, 5, 1.f, 5.f, 1);
			
			to_destroy();
		}
	}
	
	function to_destroy()
	{
		active = false;
		RemoveTimer('check_targets');
		RemoveTimer('play_eff');
		check_targets_fire();
		StopProjectile();
		DestroyAllEffects();
		PlayEffect( 'explosion' );
		DestroyAfter(5);
		SoundEvent("fx_fire_burning_body_strong_loop_end");
		SoundEvent("fx_fire_burning_strong_end");
		SoundEvent("monster_dracolizard_combat_fireball_hit");

	}
	
	event OnDestroyed()
	{
	}
	
	function check_targets_fire()
	{
		entities.Clear();
		FindGameplayEntitiesInSphere( entities, this.GetWorldPosition(), range, 10 );
		
		if ( entities.Size() > 0 )
		for( i = 0; i < entities.Size(); i += 1 )
		{
			if ( !collidedEntities2.Contains(entities[i]) && entities[i] != thePlayer && entities[i] != this && !entities[i].HasTag('spells_custom_projs') )
			{
				entities[i].OnIgniHit( NULL );
				collidedEntities2.PushBack(entities[i]);
				DealDamageToVictimProj( entities[i] );
			}
		}
	}
	
	function DealDamageToVictimProj( victim : CGameplayEntity )
	{
		var action 								: W3DamageAction;
		var victimtarget						: CActor;
		
		victimtarget = (CActor)victim;
		if ( victimtarget && victimtarget != thePlayer && GetAttitudeBetween( victimtarget, thePlayer ) == AIA_Hostile && victimtarget.IsAlive() ) 
		{
			damage = get_damage_value_for_projectile( victimtarget, spellpower_final );
			if ( !HasTag('spells_from_sign') )
			{
				damage += damage * get_manual_aiming_dmg_mod();	  
			}
			//theGame.witcherLog.AddMessage("DAMAGE ORIGINAL " + damage );
			damage -= damage * range * 0.1;
			//theGame.witcherLog.AddMessage("DAMAGE ACTUAL " + damage );
			
			action = new W3DamageAction in theGame.damageMgr;
			action.Initialize(thePlayer,victimtarget,this,thePlayer.GetName(),EHRT_Heavy,CPS_Undefined,false, false, true, false );
			action.SetProcessBuffsIfNoDamage(true);
			action.SetCanPlayHitParticle( true );
			
			if ( RandF() <=0.2 )
			{
				action.AddEffectInfo( EET_Burning, 2 );
				//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
			}
			
		
			action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage  );
			//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
			
			if ( spells_can_dismember( victimtarget ) )
			{
				action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( action );
			delete action;
			
			effect_entity = victimtarget.CreateFXEntityAtPelvis( 'fire_gnosis_effects', true );
			effect_entity.PlayEffect( 'flame' );
			effect_entity.DestroyAfter(5);
			
			victims.PushBack(victim);
		}
	}
}



class W3FireentityLine extends W3TraceGroundProjectile
{
	var action 				: W3DamageAction;
	var damage 				: float;
	var spellpower_final 	: float;
	var lastpos, pos		: Vector;

	event OnSpawned( spawnData : SEntitySpawnData )
	{	
		spellpower_final = GetMagicVigil().get_magic_spellpower();
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( !isActive || IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;
		
		super.OnProjectileCollision(pos, normal, collidingComponent, hitCollisionsGroups, actorIndex, shapeIndex);
		
		if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer && GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile && victim.IsAlive())
		{
			victim.OnIgniHit( NULL );
		
			damage = get_damage_value_for_cone_far( (CActor)victim, spellpower_final );
		
			action = new W3DamageAction in this;
			action.Initialize(thePlayer,victim,this,thePlayer.GetName(),EHRT_None,CPS_Undefined,false,false,true,false);
			action.SetProcessBuffsIfNoDamage(true);
			action.AddDamage(theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage );
			action.SetHitEffect('igni_cone_hit', false, false);
			action.SetHitEffect('igni_cone_hit', true, false);
			action.SetHitReactionType(EHRT_Igni, false);
			action.SetHitAnimationPlayType(EAHA_Default);
			
			if ( RandF() <=0.15 )
			{
				action.AddEffectInfo( EET_Burning, 2 );
				//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
			}
			
			if ( spells_can_dismember( (CActor)victim ) )
			{
				action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( action );
			collidedEntities.PushBack(victim);
			delete action;
		}
	}
}


class W3IceentityBolt extends W3AdvancedProjectile
{
	var boneName 					: name;
	var actorVictim					: CActor;
	var dmg_action                  : W3DamageAction;
	var victimsand					: CNewNPC;	
	var entities 					: array< CGameplayEntity >;
	var i	 						: int;
	var lastCollisionFxPos 			: Vector;
	var spellpower 					: SAbilityAttributeValue;
	var damage						: Float;
	var ent 						: CEntity;
	var victims						: array<CGameplayEntity>;
	var spellpower_final			: float;
	var comp						: CMeshComponent;
	var rot 						: EulerAngles;
	var rotg 						: EulerAngles;
	var x,y,z			            : float;

	event OnSpawned( spawnData : SEntitySpawnData )
	{
		x = 1.5;
		y = 1;
		z = 1.5;
	}
	
	event OnProjectileInit()
	{
		if ( HasTag('spells_from_sign') )
		{
			spellpower_final = GetMagicVigil().get_magic_spellpower();
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final + "HAS TAG" + (string)HasTag('spells_from_sign') );
		}
		else
		{
			spellpower_final = get_spellpower_spells( true );
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final );
		}
		
		GetMagicVigil().set_magic_spellpower( spellpower_final );
		
		comp = (CMeshComponent)this.GetComponentByClassName('CMeshComponent');
		comp.SetScale( Vector( x, y, z ) );
		rot = comp.GetLocalRotation();
		rot.Pitch -= 90;
		comp.SetRotation( rot );
		PlayEffect('frozen');
		PlayEffect('trail');
		PlayEffect('trail2');
		PlayEffect('trail3');
		
		SoundEvent("monster_golem_dao_cmb_swoosh_heavy");
	}
	
	timer function destroy_proj( dt : float , id : int)
	{
		AddTimer('thaw', 0.01, true );
	}
	timer function thaw( dt : float , id : int)
	{
		x -= 0.05;
		y -= 0.025;
		z -= 0.05;
		if ( x <= 0 || y <= 0 )
		{ Destroy(); }
		comp.SetScale( Vector( x, y, z ) );
	}
	
	event OnDestroyed()
	{
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		var meshComponent		: CMeshComponent;
		var arrowHitPos			: Vector;
		var arrowSize			: Vector;
		var boundingBox			: Box;
	
		if ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Static' ) )
		{
			StopEffect('trail');
			StopEffect('trail2');
			StopEffect('trail3');
			StopProjectile();
			AddTimer('destroy_proj', 5);
			
			this.SoundEvent("cmb_arrow_impact_dirt");
			
			arrowHitPos = pos;
			meshComponent = (CMeshComponent)GetComponentByClassName('CMeshComponent');
			if( meshComponent )
			{
				boundingBox = meshComponent.GetBoundingBox();
				arrowSize = boundingBox.Max - boundingBox.Min;
				//arrowHitPos -= RotForward(  this.GetWorldRotation() ) * arrowSize.X * 0.7f; 
			}
			Teleport( arrowHitPos );
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		
		if( collidingComponent )
		{	
			actorVictim = (CActor)victim;
			
			if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer && ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile) && victim.IsAlive())
			{
				DealDamageToVictimProj( victim );
			
				ent = theGame.CreateEntity( (CEntityTemplate)LoadResource( 'iceentity_effects' ), pos  );
				ent.PlayEffect('iceentity_hit');
				ent.SoundEvent( 'ep2_mutations_09_bolt_impact_armor_type' );
				ent.DestroyAfter(3);
				
				collidedEntities.PushBack(victim);
			}
		}
	}
	
	function DealDamageToVictimProj( victim : CGameplayEntity )
	{
		var action 								: W3DamageAction;
		var victimtarget						: CActor;
		
		victimtarget = (CActor)victim;
		if ( victimtarget && victimtarget != thePlayer && GetAttitudeBetween( victimtarget, thePlayer ) == AIA_Hostile && victimtarget.IsAlive() ) 
		{
			damage = get_damage_value_for_projectile( victimtarget, spellpower_final );
			if ( !HasTag('spells_from_sign') )
			{
				damage += damage * get_manual_aiming_dmg_mod();	  
			}
			
			action = new W3DamageAction in theGame.damageMgr;
			action.Initialize(thePlayer,victimtarget,this,thePlayer.GetName(),EHRT_Heavy,CPS_Undefined,false, false, true, false );
			action.SetProcessBuffsIfNoDamage(true);
			action.SetCanPlayHitParticle( true );
		
			action.AddDamage(theGame.params.DAMAGE_NAME_ELEMENTAL, sp_elem_dmg_mod() * damage * 0.5 );
			action.AddDamage(theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damage * 0.5 );
		
			action.AddEffectInfo( EET_Stagger );
			//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
			
			if ( spells_can_dismember( victimtarget ) )
			{
				action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( action );
			delete action;
			
			collidedEntities.PushBack(victim);
		}
	}
}


class W3IceentityLine extends W3TraceGroundProjectile
{
	var action 				: W3DamageAction;
	var damage 				: float;
	var spellpower_final 	: float;

	event OnSpawned( spawnData : SEntitySpawnData )
	{	
		spellpower_final = GetMagicVigil().get_magic_spellpower();
		//theGame.witcherLog.AddMessage("W3IceentityLine "  );
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( !isActive || IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;
		
		super.OnProjectileCollision(pos, normal, collidingComponent, hitCollisionsGroups, actorIndex, shapeIndex);
		
		if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer && GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile && victim.IsAlive())
		{
			damage = get_damage_value_for_cone_far( (CActor)victim, spellpower_final );
		
			action = new W3DamageAction in this;
			action.Initialize(thePlayer,victim,this,thePlayer.GetName(),EHRT_None,CPS_Undefined,false,false,true,false);
			action.SetProcessBuffsIfNoDamage(true);
			action.AddEffectInfo(EET_Knockdown, 2 );
			action.AddDamage(theGame.params.DAMAGE_NAME_ELEMENTAL, sp_elem_dmg_mod() * damage * 0.5 );
			action.AddDamage(theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damage * 0.5 );
			
			if ( spells_can_dismember( (CActor)victim ) )
			{
				action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( action );
			collidedEntities.PushBack(victim);
			delete action;
		}
	}
}


class W3SpellsStoneProj extends CProjectileTrajectory 
{	
	var damage 						: Float; 
	var effect						: CEntity;
	var spellpower 					: SAbilityAttributeValue;
	var ghpois						: SCustomEffectParams;
	var victims						: array<CGameplayEntity>;
	var spellpower_final			: float;
	var comp						: CMeshComponent;
	var rot 						: EulerAngles;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
	}
	
	event OnProjectileInit()
	{
		if ( HasTag('spells_from_sign') )
		{
			spellpower_final = GetMagicVigil().get_magic_spellpower();
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final + "HAS TAG" + (string)HasTag('spells_from_sign') );
		}
		else
		{
			spellpower_final = get_spellpower_spells( true );
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final );
		}
		
		GetMagicVigil().set_magic_spellpower( spellpower_final );
		
		comp = (CMeshComponent)this.GetComponentByClassName('CMeshComponent');
		comp.SetScale( Vector ( 0.12, 0.12, 0.12 ) );
		AddTimer( 'rotate_stone1', 0.0000001f, true );
		
		SoundEvent("monster_golem_dao_cmb_swoosh_heavy");
	}
	
	timer function rotate_stone1( dt : float , id : int)
	{
		rot = comp.GetLocalRotation();
		rot.Yaw += 60;
		rot.Roll += 60;
		comp.SetRotation( rot );
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;

		
		if ( victim && victim.IsAlive() && !victims.Contains(victim) && victim != thePlayer )
		{
			DealDamageToVictimProj( victim );
		}
		else if ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Water' ) )
		{
			stop_stone();
		}
	}
	
	function stop_stone()
	{
		RemoveTimer('rotate_stone1');
		StopProjectile();
		DestroyAllEffects();
		ApplyAppearance( 'empty' );
		PlayEffect('impact');
		SoundEvent("monster_golem_dao_dialog_mv_fs_dirt");
		comp.SetScale( Vector ( 0.f, 0.f, 0.f ) );
	}
	
	function DealDamageToVictimProj( victim : CGameplayEntity )
	{
		var action 								: W3DamageAction;
		var victimtarget						: CActor;
		
		stop_stone();
		
		victimtarget = (CActor)victim;
		if ( victimtarget && victimtarget != thePlayer && GetAttitudeBetween( victimtarget, thePlayer ) == AIA_Hostile && victimtarget.IsAlive() ) 
		{
			damage = get_damage_value_for_projectile( victimtarget, spellpower_final );
			if ( !HasTag('spells_from_sign') )
			{
				damage += damage * get_manual_aiming_dmg_mod();	  
			}
			
			//theGame.witcherLog.AddMessage("damage " + damage );
			//theGame.witcherLog.AddMessage("spellpower_final " + spellpower_final );
			
			action = new W3DamageAction in theGame.damageMgr;
			action.Initialize(thePlayer,victimtarget,this,thePlayer.GetName(),EHRT_Heavy,CPS_Undefined,false, false, true, false );
			action.SetProcessBuffsIfNoDamage(true);
			action.SetCanPlayHitParticle( true );
		
			action.AddDamage( theGame.params.DAMAGE_NAME_ELEMENTAL, sp_elem_dmg_mod() * damage  );
			action.AddEffectInfo( EET_Stagger );
			//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
			
			if ( spells_can_dismember( victimtarget ) )
			{
				action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( action );
			delete action;
			
			victims.PushBack(victim);
		}
	}
}


class W3SpellsRockPillar extends CGameplayEntity 
{	
	var entities_trap															: array< CGameplayEntity >;
	var victim 																	: CActor;
	var damage_action 															: W3DamageAction;
	var i 																		: int;
	var damage_val          													: float;
	var spellpower_final 														: float;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		AddTimer( 'apply_dmg_effect',0.3 );
		spellpower_final = GetMagicVigil().get_magic_spellpower();
	}
	
	timer function apply_dmg_effect(deltaTime : float, id : int) 
	{
		FindGameplayEntitiesInSphere(entities_trap, GetWorldPosition(), 1, 100 );
		if( entities_trap.Size()>0 )
		{
			for ( i = 0; i <= entities_trap.Size(); i+=1 )
			{
				victim = (CActor)entities_trap[i];
				
				if ( victim != thePlayer && IsRequiredAttitudeBetween(thePlayer, victim, true, false, false) )
				{
					damage_val = get_damage_value_for_cone_far( victim, spellpower_final );
				
					damage_action =  new W3DamageAction in this;
					damage_action.Initialize(thePlayer,victim,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
					damage_action.SetProcessBuffsIfNoDamage(true);
					damage_action.SetHitEffect('');
					damage_action.SetHitEffect('', true );
					damage_action.SetHitEffect('', false, true);
					damage_action.SetHitEffect('', true, true);
					
					damage_action.AddDamage( theGame.params.DAMAGE_NAME_ELEMENTAL, sp_elem_dmg_mod() * damage_val );
					if( RandF()<0.2 ) 
					{ 
						damage_action.AddEffectInfo(EET_Knockdown, 2 );
					}
					else
					{ 
						damage_action.AddEffectInfo(EET_Stagger );
					}
					
					if ( spells_can_dismember( victim ) )
					{
						damage_action.SetForceExplosionDismemberment();
					}
					
					theGame.damageMgr.ProcessAction( damage_action );
					delete damage_action;
				}
			}
		}
	}
}


class W3RockwatcherLine extends W3TraceGroundProjectile
{
	var action 				: W3DamageAction;
	var damage 				: float;
	var spellpower_final 	: float;

	event OnSpawned( spawnData : SEntitySpawnData )
	{	
		spellpower_final = GetMagicVigil().get_magic_spellpower();
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( !isActive || IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;
		
		super.OnProjectileCollision(pos, normal, collidingComponent, hitCollisionsGroups, actorIndex, shapeIndex);
		
		if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer && GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile && victim.IsAlive())
		{
			damage = get_damage_value_for_cone_far( (CActor)victim, spellpower_final );
		
			action = new W3DamageAction in this;
			action.Initialize(thePlayer,victim,this,thePlayer.GetName(),EHRT_None,CPS_Undefined,false,false,true,false);
			action.SetProcessBuffsIfNoDamage(true);
			action.AddEffectInfo(EET_Knockdown, 2 );
			action.AddDamage(theGame.params.DAMAGE_NAME_ELEMENTAL, sp_elem_dmg_mod() * damage );	
			
			if ( spells_can_dismember( (CActor)victim ) )
			{
				action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( action );
			collidedEntities.PushBack(victim);
			delete action;
		}
	}
}

class W3PermafrostDummy extends CProjectileTrajectory
{
	var fxEntity 						: CEntity;
	var comp 							: CEffectDummyComponent;
	var position 						: Vector;
	var position_0						: Vector;
	var position_1						: Vector;
	var outPosition						: Vector;
	var outNormal						: Vector;
	var position_init					: Vector;
	var i								: Int;
	var burn_ground						: CEntity;
	var temp							: string;
	var rotation 						: EulerAngles;
	var effect_name 					: name;
	var entities						: array<CGameplayEntity>;
	var entities_col					: array<CGameplayEntity>;
	var target 							: CActor;
	var targets 						: array<CActor>;
	var damage_action					: W3DamageAction;
	var damage_value					: float;
	var effect_entity					: CEntity;
	
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		SoundEvent('ep2_mutations_06_frosty_aard');
		SoundEvent("sign_aard_blast");
	
		for( i = 4; i <= 14; i += 2 )   
		{ theGame.GetSurfacePostFX().AddSurfacePostFXGroup(GetWorldPosition() + GetMagicVigil().Spells_get_hand_aim()*i, 0.1f+i*0.10, 2.f, 2.f, 20, 0 ); }
		
		AddTimer('check_for_targets_permafrost_cone', 0.01, true );
	}
	
	
	timer function check_for_targets_permafrost_cone ( dt : float, optional id : int)
	{
		FindGameplayEntitiesInCone( entities, GetWorldPosition() + GetWorldForward() * 3, VecHeading( GetWorldForward() * -1 ), 180, 4, 100 );
		if ( entities.Size() >0 )
		{
			for( i = 0; i < entities.Size(); i += 1 )
			{
				if ( !entities_col.Contains( entities[i] ) && !entities[i].HasTag('spells_custom_projs') )
				{
					entities_col.PushBack( entities[i] );
					
					entities[i].OnAardHit( NULL );
					
					target = (CActor)entities[i];
					if ( target && target != thePlayer && GetAttitudeBetween( target, thePlayer ) == AIA_Hostile && target.IsAlive() )
					{
						damage_value = get_damage_value_for_cone_far( target, GetMagicVigil().get_magic_spellpower() );
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_Heavy,CPS_Undefined,false, false, true, false );
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetCanPlayHitParticle(false);
						damage_action.SetHitAnimationPlayType(EAHA_Default);
						
						if ( RandF() <=0.25 )
						{
							damage_action.AddEffectInfo( EET_SlowdownFrost, 3 );
							//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
						}
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damage_value );
						
						effect_entity = target.CreateFXEntityAtPelvis( 'permafrost_effects', true );
						effect_entity.PlayEffect( 'flame_from_cone' );
						effect_entity.DestroyAfter(5);
						
						if ( spells_can_dismember( target ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action );
						delete damage_action;
					}
				}
			}
		}
	}
	
	event OnRangeReached()
	{
		StopProjectile();
		RemoveTimer('check_for_targets_permafrost_cone');
	}
}


class W3PermafrostSpear extends CProjectileTrajectory
{
	var damage 						: Float; 
	var effect						: CEntity;
	var spellpower 					: SAbilityAttributeValue;
	var ghpois						: SCustomEffectParams;
	var victims						: array<CGameplayEntity>;
	var spellpower_final			: float;
	var comp						: CMeshComponent;
	var range						: float;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		SoundEvent("magic_sorceress_vfx_fireball_fire_fx_loop_start");
		comp = (CMeshComponent)this.GetComponentByClassName('CMeshComponent');
		comp.SetScale( Vector ( 0.f, 0.f, 0.f ) );
		
		range = 3;
	}
	
	event OnProjectileInit()
	{
		if ( HasTag('spells_from_sign') )
		{
			spellpower_final = GetMagicVigil().get_magic_spellpower();
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final + "HAS TAG" + (string)HasTag('spells_from_sign') );
		}
		else
		{
			spellpower_final = get_spellpower_spells( true );
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final );
		}
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;

		
		if ( victim && victim.IsAlive() && !victims.Contains(victim) && victim != thePlayer )
		{
			DealDamageProj();
		}
		else if ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Water' ) )
		{
			DealDamageProj();
		}
	}
	
	function DealDamageProj()
	{
		var ent 				: CEntity;
		var damageAreaEntity 	: CDamageAreaEntity;
		var entities	 		: array<CGameplayEntity>;
		var i					: int;
		var surface				: CGameplayFXSurfacePost;
		
		FindGameplayEntitiesInSphere( entities, GetWorldPosition(), range, 100 );
		for( i = 0; i < entities.Size(); i += 1 )
		{
			DealDamageToVictimProj( entities[i] );
		}
		SoundEvent("magic_sorceress_vfx_fireball_fire_fx_loop_stop");
		StopProjectile();
		StopAllEffects();
		PlayEffect('explode');
	}
	
	function DealDamageToVictimProj( victim : CGameplayEntity )
	{
		var action 								: W3DamageAction;
		var victimtarget						: CActor;
		
		if ( !victim.HasTag('spells_custom_projs') )
		{
			victim.OnAardHit( NULL );
		}
		victimtarget = (CActor)victim;
		
		if ( victimtarget && victimtarget != thePlayer && GetAttitudeBetween( victimtarget, thePlayer ) == AIA_Hostile && victimtarget.IsAlive() ) 
		{
			damage = get_damage_value_for_projectile( victimtarget, spellpower_final );
			if ( !HasTag('spells_from_sign') )
			{
				damage += damage * get_manual_aiming_dmg_mod();	  
			}
			
			damage -= damage * range * 0.1;
			
			action = new W3DamageAction in theGame.damageMgr;
			action.Initialize(thePlayer,victimtarget,this,thePlayer.GetName(),EHRT_Heavy,CPS_Undefined,false, false, true, false );
			action.SetProcessBuffsIfNoDamage(true);
			action.SetCanPlayHitParticle(false);
			
			action.AddDamage( theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damage );
			if ( RandF() <=0.25 )
			{
				action.AddEffectInfo( EET_SlowdownFrost, 3 );
				//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
			}
			
			if ( spells_can_dismember( victimtarget ) )
			{
				action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( action );
			delete action;
			
			effect = victimtarget.CreateFXEntityAtPelvis( 'permafrost_effects', true );
			effect.PlayEffect( 'flame_from_cone' );
			effect.DestroyAfter(5);
			
		}
		victims.PushBack(victim);
	}
}

class W3FireGnosisDummy extends CProjectileTrajectory
{
	var fxEntity 						: CEntity;
	var comp 							: CEffectDummyComponent;
	var position 						: Vector;
	var position_0						: Vector;
	var position_1						: Vector;
	var outPosition						: Vector;
	var outNormal						: Vector;
	var position_init					: Vector;
	var i								: Int;
	var burn_ground						: CEntity;
	var temp							: string;
	var rotation 						: EulerAngles;
	var effect_name 					: name;
	var entities						: array<CGameplayEntity>;
	var entities_col					: array<CGameplayEntity>;
	var target 							: CActor;
	var targets 						: array<CActor>;
	var damage_action					: W3DamageAction;
	var damage_value					: float;
	var effect_entity					: CEntity;
	
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		PlayEffect( 'fire' );
		
		rotation = thePlayer.GetWorldRotation();
		rotation.Yaw += 90;
		
		position_0 = GetMagicVigil().Spells_get_hand_pos();
		position_1 = GetMagicVigil().Spells_get_hand_aim();

		AddTimer('effect_sparks', 0.3 );
		
		for( i = 6; i <= 10; i += 2 )   
		{ theGame.GetSurfacePostFX().AddSurfacePostFXGroup( GetWorldPosition() + GetMagicVigil().Spells_get_hand_aim() * i, 0.3f + i*0.05, 5.f, 2.f, 10, 1 ); }
		
		AddTimer('check_for_targets_fire_cone', 0.01, true );
	}
	
	
	timer function effect_sparks ( dt : float, optional id : int)
	{
		var z : float;
		
		temp = "dlc\magicspellsrev\data\entities\fire_gnosis.w2ent";
		effect_name = 'fire_gnosis_burn_ground';
	
		for(z = 1; z <= 10; z += 2.9 )   
		{
			burn_ground = theGame.CreateEntity( (CEntityTemplate) LoadResource( temp, true ), position_0 + position_1 * z, rotation );
			burn_ground.PlayEffect( effect_name );
			burn_ground.DestroyAfter(5);	
		}
	}
	
	timer function check_for_targets_fire_cone ( dt : float, optional id : int)
	{
		FindGameplayEntitiesInCone( entities, GetWorldPosition() + GetWorldForward() * 3, VecHeading( GetWorldForward() * -1 ), 180, 4, 100 );
		if ( entities.Size() >0 )
		{
			for( i = 0; i < entities.Size(); i += 1 )
			{
				if ( !entities_col.Contains( entities[i] ) && !entities[i].HasTag('spells_custom_projs') )
				{
					entities_col.PushBack( entities[i] );
					
					entities[i].OnIgniHit( NULL );
					
					target = (CActor)entities[i];
					if ( target && target != thePlayer && GetAttitudeBetween( target, thePlayer ) == AIA_Hostile && target.IsAlive() )
					{
						damage_value = get_damage_value_for_cone_far( target, GetMagicVigil().get_magic_spellpower() );
					
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetHitEffect('igni_cone_hit', false, false);
						damage_action.SetHitEffect('igni_cone_hit', true, false);
						damage_action.SetHitReactionType(EHRT_Igni, false);
						damage_action.SetHitAnimationPlayType(EAHA_Default);
						
						if ( RandF() <=0.25 )
						{
							damage_action.AddEffectInfo( EET_Burning, 2 );
							//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
						}
						
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage_value );
						
						effect_entity = target.CreateFXEntityAtPelvis( 'fire_gnosis_effects', true );
						effect_entity.PlayEffect( 'flame' );
						effect_entity.DestroyAfter(5);
						
						if ( spells_can_dismember( target ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action );
						delete damage_action;
					}
				}
			}
		}
	}
	
	event OnRangeReached()
	{
		StopProjectile();
		StopEffect('fire');
		RemoveTimer('check_for_targets_fire_cone');
	}
}

class W3FireGnosisFireball extends CProjectileTrajectory
{
	var damage 						: Float; 
	var gheff						: CEntity;
	var spellpower 					: SAbilityAttributeValue;
	var ghpois						: SCustomEffectParams;
	var victims						: array<CGameplayEntity>;
	var spellpower_final			: float;
	var comp						: CMeshComponent;
	var range						: float;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		comp = (CMeshComponent)this.GetComponentByClassName('CMeshComponent');
		comp.SetScale( Vector ( 0.f, 0.f, 0.f ) );
	}
	
	event OnProjectileInit()
	{
		if ( HasTag('spells_from_sign') )
		{
			spellpower_final = GetMagicVigil().get_magic_spellpower();
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final + "HAS TAG" + (string)HasTag('spells_from_sign') );
		}
		else
		{
			spellpower_final = get_spellpower_spells( true );
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final );
		}
		
		range = 1.5;
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;

		
		if ( victim && victim.IsAlive() && !victims.Contains(victim) && victim != thePlayer )
		{
			DealDamageProj();
		}
		else if ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Water' ) )
		{
			DealDamageProj();
		}
	}
	
	function DealDamageProj()
	{
		var ent 				: CEntity;
		var damageAreaEntity 	: CDamageAreaEntity;
		var entities	 		: array<CGameplayEntity>;
		var i					: int;
		var surface				: CGameplayFXSurfacePost;
		
		FindGameplayEntitiesInSphere( entities, GetWorldPosition(), range, 100 );
		for( i = 0; i < entities.Size(); i += 1 )
		{
			DealDamageToVictimProj( entities[i] );
		}
		StopProjectile();
		StopAllEffects();
		PlayEffect('explosion');
	}
	
	function DealDamageToVictimProj( victim : CGameplayEntity )
	{
		var action 								: W3DamageAction;
		var victimtarget						: CActor;
		
		victim.OnIgniHit( NULL );
		victimtarget = (CActor)victim;
		if ( victimtarget && victimtarget != thePlayer && GetAttitudeBetween( victimtarget, thePlayer ) == AIA_Hostile && victimtarget.IsAlive() ) 
		{
			damage = get_damage_value_for_projectile( victimtarget, spellpower_final );
			if ( !HasTag('spells_from_sign') )
			{
				damage += damage * get_manual_aiming_dmg_mod();	  
			}
			//theGame.witcherLog.AddMessage("DAMAGE ORIGINAL " + damage );
			damage -= damage * range * 0.1;
			//theGame.witcherLog.AddMessage("DAMAGE ACTUAL " + damage );
			
			action = new W3DamageAction in theGame.damageMgr;
			action.Initialize(thePlayer,victimtarget,this,thePlayer.GetName(),EHRT_Heavy,CPS_Undefined,false, false, true, false );
			action.SetProcessBuffsIfNoDamage(true);
			action.SetCanPlayHitParticle(false);
			
			action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage );
			if ( RandF() <=0.25 )
			{
				action.AddEffectInfo( EET_Burning, 2 );
				//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
			}
			
			if ( spells_can_dismember( victimtarget ) )
			{
				action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( action );
			delete action;
		}
		victims.PushBack(victim);
	}
}


class W3BlackFireball extends CProjectileTrajectory
{
	var damage 						: Float; 
	var effect						: CEntity;
	var spellpower 					: SAbilityAttributeValue;
	var ghpois						: SCustomEffectParams;
	var victims						: array<CGameplayEntity>;
	var spellpower_final			: float;
	var comp						: CMeshComponent;
	var range						: float;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		comp = (CMeshComponent)this.GetComponentByClassName('CMeshComponent');
		comp.SetScale( Vector ( 0.f, 0.f, 0.f ) );
	}
	
	event OnProjectileInit()
	{
		if ( HasTag('spells_from_sign') )
		{
			spellpower_final = GetMagicVigil().get_magic_spellpower();
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final + "HAS TAG" + (string)HasTag('spells_from_sign') );
		}
		else
		{
			spellpower_final = get_spellpower_spells( true );
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final );
		}
		
		GetMagicVigil().set_magic_spellpower( spellpower_final );
		
		range = 3;
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;

		
		if ( victim && victim.IsAlive() && !victims.Contains(victim) && victim != thePlayer )
		{
			DealDamageProj();
		}
		else if ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Water' ) )
		{
			DealDamageProj();
		}
	}
	
	function DealDamageProj()
	{
		var ent 				: CEntity;
		var damageAreaEntity 	: CDamageAreaEntity;
		var entities	 		: array<CGameplayEntity>;
		var i					: int;
		var surface				: CGameplayFXSurfacePost;
		
		FindGameplayEntitiesInSphere( entities, GetWorldPosition(), range, 100 );
		for( i = 0; i < entities.Size(); i += 1 )
		{
			DealDamageToVictimProj( entities[i] );
		}
		StopProjectile();
		StopAllEffects();
		PlayEffect('venom_hit');
	}
	
	function DealDamageToVictimProj( victim : CGameplayEntity )
	{
		var action 								: W3DamageAction;
		var victimtarget						: CActor;
		
		victimtarget = (CActor)victim;
		if ( victimtarget && victimtarget != thePlayer && GetAttitudeBetween( victimtarget, thePlayer ) == AIA_Hostile && victimtarget.IsAlive() ) 
		{
			damage = get_damage_value_for_projectile( victimtarget, spellpower_final );
			if ( !HasTag('spells_from_sign') )
			{
				damage += damage * get_manual_aiming_dmg_mod();	  
			}
			//theGame.witcherLog.AddMessage("DAMAGE ORIGINAL " + damage );
			damage -= damage * range * 0.1;
			//theGame.witcherLog.AddMessage("DAMAGE ACTUAL " + damage );
			
			action = new W3DamageAction in theGame.damageMgr;
			action.Initialize(thePlayer,victimtarget,this,thePlayer.GetName(),EHRT_Heavy,CPS_Undefined,false, false, true, false );
			action.SetProcessBuffsIfNoDamage(true);
			action.SetCanPlayHitParticle(false);
		
			action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage * 0.6 );
			action.AddDamage( theGame.params.DAMAGE_NAME_ELEMENTAL, sp_elem_dmg_mod() * damage * 0.6 );
			action.AddEffectInfo( EET_SpellsSlowDownAverage, MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
			//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
			
			if ( spells_can_dismember( victimtarget ) )
			{
				action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( action );
			delete action;
			
			effect = victimtarget.CreateFXEntityAtPelvis( 'black_fire_effects', true );
			effect.PlayEffect( 'black_flame' );			
			effect.DestroyAfter(3);
			
		}
		victims.PushBack(victim);
	}
}

class W3GreatSwampDummy extends CProjectileTrajectory
{
	var fxEntity 						: CEntity;
	var comp 							: CEffectDummyComponent;
	var position 						: Vector;
	var position_0						: Vector;
	var position_1						: Vector;
	var outPosition						: Vector;
	var outNormal						: Vector;
	var position_init					: Vector;
	var i								: Int;
	var burn_ground						: CEntity;
	var temp							: string;
	var rotation 						: EulerAngles;
	var effect_name 					: name;
	var entities						: array<CGameplayEntity>;
	var entities_col					: array<CGameplayEntity>;
	var target 							: CActor;
	var targets 						: array<CActor>;
	var damage_action					: W3DamageAction;
	var damage_value					: float;
	var effect_entity					: CEntity;
	
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		PlayEffect( 'fire' );
		
		rotation = thePlayer.GetWorldRotation();
		rotation.Yaw += 90;
		
		position_0 = GetMagicVigil().Spells_get_hand_pos();
		position_1 = GetMagicVigil().Spells_get_hand_aim();

		AddTimer('effect_sparks', 0.3 );
		
		AddTimer('check_for_targets_fire_cone', 0.01, true );
	}
	
	
	timer function effect_sparks ( dt : float, optional id : int)
	{
		var z : float;
		
		temp = "dlc\magicspellsrev\data\entities\great_swamp.w2ent";
		effect_name = 'great_swamp_burn_ground';
	
		for(z = 1; z <= 10; z += 2.9 )   
		{
			burn_ground = theGame.CreateEntity( (CEntityTemplate) LoadResource( temp, true ), position_0 + position_1 * z, rotation );
			burn_ground.PlayEffect( effect_name );
			burn_ground.DestroyAfter(5);	
		}
	}
	
	timer function check_for_targets_fire_cone ( dt : float, optional id : int)
	{
		FindGameplayEntitiesInCone( entities, GetWorldPosition() + GetWorldForward() * 3, VecHeading( GetWorldForward() * -1 ), 180, 4, 100 );
		if ( entities.Size() >0 )
		{
			for( i = 0; i < entities.Size(); i += 1 )
			{
				if ( !entities_col.Contains( entities[i] ) && !entities[i].HasTag('spells_custom_projs') )
				{
					entities_col.PushBack( entities[i] );
					
					target = (CActor)entities[i];
					if ( target && target != thePlayer && GetAttitudeBetween( target, thePlayer ) == AIA_Hostile && target.IsAlive() )
					{
						damage_value = get_damage_value_for_cone_far( target, GetMagicVigil().get_magic_spellpower() );
					
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetHitEffect('');
						damage_action.SetHitEffect('', true );
						damage_action.SetHitEffect('', false, true);
						damage_action.SetHitEffect('', true, true);
						damage_action.SetHitReactionType(EHRT_Heavy);
						damage_action.SetHitAnimationPlayType(EAHA_Default);
						
						if ( RandF() <=0.5 )
						{
							damage_action.AddEffectInfo( EET_Poison, 4 );
							//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
						}
						
						damage_action.AddDamage(theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage_value * 0.6 );
						damage_action.AddDamage(theGame.params.DAMAGE_NAME_POISON, sp_pois_dmg_mod() * damage_value * 0.6 );
						
						effect_entity = target.CreateFXEntityAtPelvis( 'great_swamp_effects', true );
						effect_entity.PlayEffect( 'flame_from_cone' );
						effect_entity.DestroyAfter(5);
						
						if ( spells_can_dismember( target ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action );
						delete damage_action;
					}
				}
			}
		}
	}
	
	event OnRangeReached()
	{
		StopProjectile();
		StopEffect('fire');
		RemoveTimer('check_for_targets_fire_cone');
	}
}


class W3GreatSwampVenom extends CProjectileTrajectory
{
	var damage 						: Float; 
	var effect						: CEntity;
	var spellpower 					: SAbilityAttributeValue;
	var ghpois						: SCustomEffectParams;
	var victims						: array<CGameplayEntity>;
	var spellpower_final			: float;
	var comp						: CMeshComponent;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		comp = (CMeshComponent)this.GetComponentByClassName('CMeshComponent');
		comp.SetScale( Vector ( 0.f, 0.f, 0.f ) );
	}
	
	event OnProjectileInit()
	{
		if ( HasTag('spells_from_sign') )
		{
			spellpower_final = GetMagicVigil().get_magic_spellpower();
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final + "HAS TAG" + (string)HasTag('spells_from_sign') );
		}
		else
		{
			spellpower_final = get_spellpower_spells( true );
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final );
		}
		
		GetMagicVigil().set_magic_spellpower( spellpower_final );
		
		//SoundEvent("magic_sorceress_vfx_fireball_fire_fx_loop_start");
		SoundEvent("monster_scolopendromorph_combat_venom_flyby");
		SoundEvent("monster_scolopendromorph_combat_venom_projectile_LP");
		
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;

		
		if ( victim && victim.IsAlive() && !victims.Contains(victim) && victim != thePlayer )
		{
			StopVenom();
			DealDamageToVictimProj( victim );
		}
		else
		if ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Water' ) )
		{
			StopVenom();
		}
	}
	
	function StopVenom()
	{
		var ent 				: CEntity;
		var damageAreaEntity 	: CDamageAreaEntity;
		var entities	 		: array<CGameplayEntity>;
		var i					: int;
		var surface				: CGameplayFXSurfacePost;
		var area				: SpellsPoisonArea;
		var pos 				: Vector;
		
		SoundEvent("monster_scolopendromorph_combat_venom_hit");
		//SoundEvent("magic_sorceress_vfx_fireball_fire_fx_loop_stop");
		SoundEvent("monster_scolopendromorph_combat_venom_projectile_LP_stop");
		
		StopProjectile();
		StopAllEffects();
		PlayEffect('venom_hit');
		
		pos = GetWorldPosition();
		area = (SpellsPoisonArea)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\great_swamp_poison_area.w2ent", true ), TraceFloor(pos)  );
		area.AddTimer('destroy_poison_area', 5);
	}
	
	function DealDamageToVictimProj( victim : CGameplayEntity )
	{
		var action 								: W3DamageAction;
		var victimtarget						: CActor;
		
		victimtarget = (CActor)victim;
		if ( victimtarget && victimtarget != thePlayer && GetAttitudeBetween( victimtarget, thePlayer ) == AIA_Hostile && victimtarget.IsAlive() ) 
		{
			damage = get_damage_value_for_projectile( victimtarget, spellpower_final );
			if ( !HasTag('spells_from_sign') )
			{
				damage += damage * get_manual_aiming_dmg_mod();	  
			}
			
			action = new W3DamageAction in theGame.damageMgr;
			action.Initialize(thePlayer,victimtarget,this,thePlayer.GetName(),EHRT_Heavy,CPS_Undefined,false, false, true, false );
			action.SetProcessBuffsIfNoDamage(true);
			action.SetCanPlayHitParticle(false);
		
			action.AddDamage( theGame.params.DAMAGE_NAME_POISON, sp_pois_dmg_mod() * damage );
			action.AddEffectInfo( EET_Poison, MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
			//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
			
			/*
			if ( spells_can_dismember( victimtarget ) )
			{
				action.SetForceExplosionDismemberment();
			}
			*/
			
			theGame.damageMgr.ProcessAction( action );
			delete action;
		}
		victims.PushBack(victim);
	}
}


class W3MeteorFireSpells extends CProjectileTrajectory
{
	editable var explosionRadius 		: float;
	editable var markerEntityTemplate	: CEntityTemplate;
	editable var destroyMarkerAfter		: float;

	var markerEntity 			: CEntity;
	var victimtarget			: CActor;
	var collidedEntities		: array<CGameplayEntity>;
	var active					: bool;
	
	
	default explosionRadius = 3;
	default destroyMarkerAfter = 2.f;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		active = true;
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( IsStopped() || !active )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;

		
		if ( victim && victim.IsAlive() && victim != thePlayer )
		{
			Explode_met_spells();
		}
		else
		if ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Water' ) || hitCollisionsGroups.Contains( 'Static' ) )
		{
			Explode_met_spells();
		}
	}
	
	protected function Explode_met_spells()
	{
		var entities 		: array<CGameplayEntity>;
		var i				: int;
		
		active = false;
		
		FindGameplayEntitiesInCylinder( entities, this.GetWorldPosition(), explosionRadius, 2.f, 99 ,'',FLAG_ExcludeTarget, this );
		
		for( i = 0; i < entities.Size(); i += 1 )
		{
			if ( !collidedEntities.Contains( entities[i] ) )
			{
				if ( !entities[i].HasTag('spells_custom_projs') )
				{
					entities[i].OnIgniHit( NULL );
				}
			
				collidedEntities.PushBack( entities[i] );
				victimtarget = (CActor)entities[i];
				if ( victimtarget && ( victimtarget == thePlayer || GetAttitudeBetween( victimtarget, thePlayer ) == AIA_Hostile ) && victimtarget.IsAlive() )
				{
					DealDamageToVictim_meteor_spells ( victimtarget );
				}
			}
		}
		
		StopAllEffects();
		PlayEffect( 'explosion' );
		
		DestroyAfter(10);
		
		GCameraShake( 2, 5, GetWorldPosition() );
	}
	
	protected function DealDamageToVictim_meteor_spells( victim : CActor )
	{
		var action 					: W3DamageAction;
		var damage_value			: float;
		
		damage_value = get_damage_value_for_meteors( victim, get_spellpower_spells( true ) );
		
		action = new W3DamageAction in theGame;
		action.Initialize( thePlayer,victim,this,thePlayer.GetName()+"_sign",EHRT_Light,CPS_Undefined,false,false,true,false);
		action.SetProcessBuffsIfNoDamage(true);
		action.AddDamage(theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage_value );
		if ( victim != thePlayer )
		{
			if ( RandF() <=0.25 )
			{
				action.AddEffectInfo( EET_Burning, 2 );
				//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
			}
		}
		else
		{
			action.SetHitAnimationPlayType( EAHA_ForceYes );
		}
		action.SetCanPlayHitParticle(false);
		
		if ( spells_can_dismember( victim ) )
		{
			action.SetForceExplosionDismemberment();
		}
		
		theGame.damageMgr.ProcessAction( action );
		delete action;
	}
}

class W3MeteorFrostSpells extends CProjectileTrajectory
{
	editable var explosionRadius 		: float;
	editable var markerEntityTemplate	: CEntityTemplate;
	editable var destroyMarkerAfter		: float;

	var markerEntity 			: CEntity;
	var victimtarget			: CActor;
	var collidedEntities		: array<CGameplayEntity>;
	var active 					: bool;
	
	
	default explosionRadius = 3;
	default destroyMarkerAfter = 2.f;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		active = true;
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( IsStopped() || !active )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;

		
		if ( victim && victim.IsAlive() && victim != thePlayer )
		{
			Explode_met_spells();
		}
		else
		if ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Water' ) || hitCollisionsGroups.Contains( 'Static' ) )
		{
			Explode_met_spells();
		}
	}
	
	protected function Explode_met_spells()
	{
		var entities 		: array<CGameplayEntity>;
		var i				: int;
		
		active = false;
		
		FindGameplayEntitiesInCylinder( entities, this.GetWorldPosition(), explosionRadius, 2.f, 99 ,'',FLAG_ExcludeTarget, this );
		
		for( i = 0; i < entities.Size(); i += 1 )
		{
			if ( !collidedEntities.Contains( entities[i] ) )
			{
				if ( !entities[i].HasTag('spells_custom_projs') )
				{
					entities[i].OnAardHit( NULL );
				}
			
				collidedEntities.PushBack( entities[i] );
				victimtarget = (CActor)entities[i];
				if ( victimtarget && ( victimtarget == thePlayer || GetAttitudeBetween( victimtarget, thePlayer ) == AIA_Hostile ) && victimtarget.IsAlive() )
				{
					DealDamageToVictim_meteor_spells ( victimtarget );
				}
			}
		}

		StopAllEffects();
		PlayEffect( 'explosion' );
		DestroyAfter(10);
		
		GCameraShake( 2, 5, GetWorldPosition() );
	}
	
	protected function DealDamageToVictim_meteor_spells( victim : CActor )
	{
		var action 					: W3DamageAction;
		var damage_value			: float;
		
		damage_value = get_damage_value_for_meteors( victim, get_spellpower_spells( true ) );
		
		action = new W3DamageAction in theGame;
		action.Initialize( thePlayer,victim,this,thePlayer.GetName()+"_sign",EHRT_Light,CPS_Undefined,false,false,true,false);
		action.SetProcessBuffsIfNoDamage(true);
		action.AddDamage(theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damage_value );
		
		if ( victim != thePlayer )
		{
			if( RandF() <= 0.25 )
			{
				action.AddEffectInfo( EET_Frozen, 3 );
			}
			else
			{
				action.AddEffectInfo( EET_SlowdownFrost, 5 );
			}
		}
		else
		{
			action.SetHitAnimationPlayType( EAHA_ForceYes );
		}
		
		action.SetCanPlayHitParticle(false);
		
		if ( spells_can_dismember( victim ) )
		{
			action.SetForceExplosionDismemberment();
		}
		
		theGame.damageMgr.ProcessAction( action );
		delete action;
	}
}

class W3IceBlastSpell extends CGameplayEntity
{
	editable var explodeAfter : float;
	editable var damageRadius : float;
	editable var damageVal : float;
	editable var effectDuration : float;
	
	var meshComp : CMeshComponent;
	var destructionComp	: CDestructionSystemComponent;
	var entitiesInRange : array< CGameplayEntity >;
	
	default explodeAfter = 2.0;
	default damageRadius = 3;
	default damageVal = 50;
	default effectDuration = 4.0;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		destructionComp = (CDestructionSystemComponent)GetComponentByClassName( 'CDestructionSystemComponent' );
		meshComp = (CMeshComponent)GetComponentByClassName( 'CMeshComponent' );
		if( meshComp )
		{
			meshComp.SetVisible( false );
		}
	}
	
	public function Appear()
	{
		meshComp.SetVisible( true );
		PlayEffect( 'appear' );
		PlayEffect( 'tell' );
		AddTimer( 'Explode', explodeAfter );
		DestroyAfter( explodeAfter + 5.0 );
	}
	
	timer function Explode( deltaTime : float, optional id : int )
	{
		var damage : W3DamageAction;
		var i : int;
		var actor : CActor;

		StopAllEffects();
		PlayEffect( 'explosion' );
		meshComp.SetVisible( false );
		
		GCameraShake( 0.5, true, GetWorldPosition(), 20.0f );

		FindGameplayEntitiesInRange( entitiesInRange, this, damageRadius, 1000 );	
		entitiesInRange.Remove( this );
		for( i = 0; i < entitiesInRange.Size(); i += 1 )
		{
			if ( !entitiesInRange[i].HasTag('spells_custom_projs') )
			{
				entitiesInRange[i].OnAardHit( NULL );
			}
		
			actor = (CActor)entitiesInRange[i];
			if( actor && ( actor == thePlayer || GetAttitudeBetween( actor, thePlayer ) == AIA_Hostile ) && actor.IsAlive() )
			{
				damageVal = get_damage_value_for_iceblast( actor, get_spellpower_spells( true ) );
			
				damage = new W3DamageAction in this;
				damage.Initialize( thePlayer, actor, this, thePlayer.GetName()+"_sign", EHRT_Heavy, CPS_Undefined, false, false, true, false );
				damage.SetProcessBuffsIfNoDamage(true);
				damage.AddDamage( theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damageVal );
				
				if ( actor != thePlayer )
				{
					if( RandF() <= 0.25 )
					{
						damage.AddEffectInfo( EET_Frozen, 3 );
					}
					else
					{
						damage.AddEffectInfo( EET_SlowdownFrost, 5 );
					}
				}
				else
				{
					damage.SetHitAnimationPlayType( EAHA_ForceYes );
				}
			
				if ( spells_can_dismember( actor ) )
				{
					damage.SetForceExplosionDismemberment();
				}
			
				theGame.damageMgr.ProcessAction( damage );
				delete damage;
			}
		}
	}
}

class W3QuilegMeteor extends CProjectileTrajectory
{
	var damage 						: Float; 
	var gheff						: CEntity;
	var spellpower 					: SAbilityAttributeValue;
	var ghpois						: SCustomEffectParams;
	var victims						: array<CGameplayEntity>;
	var spellpower_final			: float;
	var comp						: CMeshComponent;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		PlayEffect('venom');
	}
	
	event OnProjectileInit()
	{
		if ( HasTag('spells_from_sign') )
		{
			spellpower_final = GetMagicVigil().get_magic_spellpower();
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final + "HAS TAG" + (string)HasTag('spells_from_sign') );
		}
		else
		{
			spellpower_final = get_spellpower_spells( true );
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final );
		}
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;

		
		if ( victim && victim.IsAlive() && !victims.Contains(victim) && victim != thePlayer )
		{
			DealDamageProj();
		}
		else if ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Water' ) )
		{
			DealDamageProj();
		}
	}
	
	function DealDamageProj()
	{
		var ent 				: CEntity;
		var damageAreaEntity 	: CDamageAreaEntity;
		var entities	 		: array<CGameplayEntity>;
		var i					: int;
		var surface				: CGameplayFXSurfacePost;
		
		FindGameplayEntitiesInSphere( entities, GetWorldPosition(), 2.5, 100 );
		for( i = 0; i < entities.Size(); i += 1 )
		{
			DealDamageToVictimProj( entities[i] );
		}
		StopProjectile();
		StopAllEffects();
		PlayEffect('venom_hit');
	}
	
	function DealDamageToVictimProj( victim : CGameplayEntity )
	{
		var action 								: W3DamageAction;
		var victimtarget						: CActor;
		
		victim.OnIgniHit( NULL );
		victimtarget = (CActor)victim;
		
		if ( victimtarget && ( victimtarget == thePlayer || GetAttitudeBetween( victimtarget, thePlayer ) == AIA_Hostile ) && victimtarget.IsAlive() )
		{
			damage = get_damage_value_for_quilegmet( victimtarget, spellpower_final );
			
			action = new W3DamageAction in theGame.damageMgr;
			action.Initialize(thePlayer,victimtarget,this,thePlayer.GetName(),EHRT_Heavy,CPS_Undefined,false, false, true, false );
			action.SetProcessBuffsIfNoDamage(true);
			action.SetCanPlayHitParticle(false);
			
			action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage );
			if ( victimtarget != thePlayer )
			{
				if ( RandF() <=0.25 )
				{
					action.AddEffectInfo( EET_Burning, 2 );
					//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
				}
			}
			else
			{
				action.SetHitAnimationPlayType( EAHA_ForceYes );
			}
			if ( spells_can_dismember( victimtarget ) )
			{
				action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( action );
			delete action;
		}
		victims.PushBack(victim);
	}
}

class W3SunSpear extends CProjectileTrajectory
{
	var damage 						: Float; 
	var effect						: CEntity;
	var spellpower 					: SAbilityAttributeValue;
	var ghpois						: SCustomEffectParams;
	var victims						: array<CGameplayEntity>;
	var spellpower_final			: float;
	var comp						: CMeshComponent;
	var range						: float;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		SoundEvent("magic_sorceress_vfx_fireball_fire_fx_loop_start");
		comp = (CMeshComponent)this.GetComponentByClassName('CMeshComponent');
		comp.SetScale( Vector ( 0.f, 0.f, 0.f ) );
	}
	
	event OnProjectileInit()
	{
		if ( HasTag('spells_from_sign') )
		{
			spellpower_final = GetMagicVigil().get_magic_spellpower();
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final + "HAS TAG" + (string)HasTag('spells_from_sign') );
		}
		else
		{
			spellpower_final = get_spellpower_spells( true );
			//theGame.witcherLog.AddMessage("SPELL POWER = " + (string)spellpower_final );
			//theGame.witcherLog.AddMessage("MANUAL AIMING   "  );
		}
		
		range = 3;
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;

		
		if ( victim && victim.IsAlive() && !victims.Contains(victim) && victim != thePlayer )
		{
			DealDamageProj();
		}
		else if ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Water' ) )
		{
			DealDamageProj();
		}
	}
	
	function DealDamageProj()
	{
		var ent 				: CEntity;
		var damageAreaEntity 	: CDamageAreaEntity;
		var entities	 		: array<CGameplayEntity>;
		var i					: int;
		var surface				: CGameplayFXSurfacePost;
		
		FindGameplayEntitiesInSphere( entities, GetWorldPosition(), range, 100 );
		for( i = 0; i < entities.Size(); i += 1 )
		{
			DealDamageToVictimProj( entities[i] );
		}
		StopProjectile();
		StopAllEffects();
		PlayEffect('explode');
		PlayEffect('explode2');
		PlayEffect('explode3');
		SoundEvent("fx_other_lightning_pre_2s");
		SoundEvent('magic_sorceress_vfx_arcane_explode');
		SoundEvent("magic_sorceress_vfx_fireball_fire_fx_loop_stop");
	}
	
	function DealDamageToVictimProj( victim : CGameplayEntity )
	{
		var action 								: W3DamageAction;
		var victimtarget						: CActor;
		var effect_expl							: CEntity;
		
		victimtarget = (CActor)victim;
		
		if ( victimtarget && victimtarget != thePlayer && GetAttitudeBetween( victimtarget, thePlayer ) == AIA_Hostile && victimtarget.IsAlive() ) 
		{
			damage = get_damage_value_for_projectile( victimtarget, spellpower_final );
			
			//theGame.witcherLog.AddMessage("SPELL POWER   = " + (string)spellpower_final );
			
			if ( !HasTag('spells_from_sign') )
			{
				damage += damage * get_manual_aiming_dmg_mod();	  
			}
			//theGame.witcherLog.AddMessage("DAMAGE  = " + (string)damage );
			//theGame.witcherLog.AddMessage("DAMAGE ORIGINAL " + damage );
			damage -= damage * range * 0.1;
			//theGame.witcherLog.AddMessage("DAMAGE ACTUAL " + damage );
			
			action = new W3DamageAction in theGame.damageMgr;
			action.Initialize(thePlayer,victimtarget,this,thePlayer.GetName(),EHRT_Heavy,CPS_Undefined,false, false, true, false );
			action.SetProcessBuffsIfNoDamage(true);
			action.SetCanPlayHitParticle(false);
			
			action.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * damage *0.7 );
			action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() *  damage *0.5 );
			
			if ( spells_can_dismember( victimtarget ) )
			{
				action.SetForceExplosionDismemberment();
			}
			
			effect_expl = victimtarget.CreateFXEntityAtPelvis( 'explosions', true );
			effect_expl.PlayEffect( 'old_gods_hit' );
			effect_expl.DestroyAfter(5);
			
			theGame.damageMgr.ProcessAction( action );
			delete action;
			
			
		}
		victims.PushBack(victim);
	}
}

class W3WitchRoot extends CGameplayEntity
{
	var range 	: float;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		PlayEffect('ground_fx');
		//theGame.witcherLog.AddMessage("Witch's Root " );
		AddTimer('effect', 0.3);
		AddTimer('attack', 0.4);
		AddTimer('stop_eff', 1.f);
		
		range = 3;
		
	}

	timer function effect ( dt : float, optional id : int)
	{
		PlayEffect('attack_fx1');
	}

	timer function attack ( dt : float, optional id : int)
	{
		var entities	 		: array<CGameplayEntity>;
		var i					: int;
		
		FindGameplayEntitiesInSphere( entities, GetWorldPosition(), range, 100 );
		for( i = 0; i < entities.Size(); i += 1 )
		{
			deal_damage( (CActor)entities[i] );
		}
	}
	
	function deal_damage( victimtarget : CActor )
	{
		var action 			: W3DamageAction;
		var damage 			: float;
		
		if ( victimtarget && ( victimtarget == thePlayer || GetAttitudeBetween( victimtarget, thePlayer ) == AIA_Hostile ) && victimtarget.IsAlive() ) 
		{
			damage = get_damage_value_for_projectile( victimtarget, GetMagicVigil().get_magic_spellpower(), true );
			//theGame.witcherLog.AddMessage("DAMAGE ORIGINAL " + damage );
			damage -= damage * range * 0.1;
			//theGame.witcherLog.AddMessage("DAMAGE ACTUAL " + damage );
			
			//theGame.witcherLog.AddMessage("damage " + damage );
			//theGame.witcherLog.AddMessage("spellpower_final " + GetMagicVigil().get_magic_spellpower() );
			
			action = new W3DamageAction in theGame.damageMgr;
			action.Initialize(thePlayer,victimtarget,this,thePlayer.GetName(),EHRT_Heavy,CPS_Undefined,false, false, true, false );
			action.SetProcessBuffsIfNoDamage(true);
			action.SetCanPlayHitParticle( true );
			
			if ( victimtarget == thePlayer )
			{
				damage = damage - ( damage * ( GetMagicVigil().get_magic_spellpower() * get_spellpower_mult() ) );
				action.SetHitAnimationPlayType( EAHA_ForceYes );
			}
			else
			{
				if ( RandF() <=0.3 )
				{
					action.AddEffectInfo( EET_Bleeding, 3 );
				}
				action.AddEffectInfo( EET_LongStagger );
			}

			action.AddDamage( theGame.params.DAMAGE_NAME_ELEMENTAL, sp_elem_dmg_mod() * damage  );
			
			if ( spells_can_dismember( victimtarget ) )
			{
				action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( action );
			delete action;
		}
	}
	
	timer function stop_eff ( dt : float, optional id : int)
	{
		StopEffect('ground_fx');
	}

	event OnDestroyed()
	{
	}
}


class W3SwordYrdenConeDummy extends CProjectileTrajectory
{
	var fxEntity 						: CEntity;
	var comp 							: CEffectDummyComponent;
	var position 						: Vector;
	var position_0						: Vector;
	var position_1						: Vector;
	var outPosition						: Vector;
	var outNormal						: Vector;
	var position_init					: Vector;
	var i								: Int;
	var burn_ground						: CEntity;
	var temp							: string;
	var rotation 						: EulerAngles;
	var effect_name 					: name;
	var entities						: array<CGameplayEntity>;
	var entities_col					: array<CGameplayEntity>;
	var target 							: CActor;
	var targets 						: array<CActor>;
	var damage_action					: W3DamageAction;
	var damage_value					: float;
	var effect_entity					: CEntity;
	var slow 							: SCustomEffectParams;	
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		AddTimer('check_for_targets_sword_yrden_cone', 0.01, true );
	}
	
	
	timer function check_for_targets_sword_yrden_cone ( dt : float, optional id : int)
	{
		FindGameplayEntitiesInCone( entities, GetWorldPosition() + GetWorldForward() * 3, VecHeading( GetWorldForward() * -1 ), 180, 4, 100 );
		if ( entities.Size() >0 )
		{
			for( i = 0; i < entities.Size(); i += 1 )
			{
				if ( !entities_col.Contains( entities[i] ) && !entities[i].HasTag('spells_custom_projs') )
				{
					entities_col.PushBack( entities[i] );
					
					target = (CActor)entities[i];
					if ( target && target != thePlayer && GetAttitudeBetween( target, thePlayer ) == AIA_Hostile && target.IsAlive() )
					{
					
						slow.effectType = EET_Slowdown;
						slow.creator = thePlayer;
						slow.sourceName = thePlayer.GetName();
						slow.duration = get_spellpower_spells( false, S_Magic_3 ) * 3;
						
						//theGame.witcherLog.AddMessage("duration = " + get_spellpower_spells( false, S_Magic_1 ) * 4 );
						
						slow.customPowerStatValue = GetWitcherPlayer().GetTotalSignSpellPower(S_Magic_3);
						slow.effectValue.valueAdditive = 0.01 + (0.99 - 0.01) * slow.customPowerStatValue.valueMultiplicative / 5;
						slow.effectValue.valueAdditive = ClampF( slow.effectValue.valueAdditive, 0.01, 0.99 );				
						target.AddEffectCustom(slow);
						
						//theGame.witcherLog.AddMessage("Spellpower Final  " + get_spellpower_spells( false, S_Magic_1 ) );
						//theGame.witcherLog.AddMessage("Spellpower Final  " + GetMagicVigil().get_magic_spellpower()   );
						
					
						damage_value = get_damage_value_for_cone_far( target, GetMagicVigil().get_magic_spellpower() );
						damage_value *= get_sword_spells_dmg_mod();
						damage_value += damage_value * get_overall_mult();
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_Heavy,CPS_Undefined,false, false, true, false );
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetCanPlayHitParticle(false);
						damage_action.SetHitAnimationPlayType(EAHA_Default);
						
						damage_action.SetHitEffect('');
						damage_action.SetHitEffect('', true );
						damage_action.SetHitEffect('', false, true);
						damage_action.SetHitEffect('', true, true);
						
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * damage_value );
						
						effect_entity = target.CreateFXEntityAtPelvis( 'sword_ring_small_effects', true );
						effect_entity.PlayEffect( 'yrden_shock_cut' );
						effect_entity.DestroyAfter(5);
						target.SoundEvent("sign_yrden_shock_activate");
						
						if ( spells_can_dismember( target ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action );
						delete damage_action;
					}
				}
			}
		}
	}
	
	event OnRangeReached()
	{
		StopProjectile();
		RemoveTimer('check_for_targets_sword_yrden_cone');
	}
}

class W3SwordAardConeDummy extends CProjectileTrajectory
{
	var fxEntity 						: CEntity;
	var comp 							: CEffectDummyComponent;
	var position 						: Vector;
	var position_0						: Vector;
	var position_1						: Vector;
	var outPosition						: Vector;
	var outNormal						: Vector;
	var position_init					: Vector;
	var i								: Int;
	var burn_ground						: CEntity;
	var temp							: string;
	var rotation 						: EulerAngles;
	var effect_name 					: name;
	var entities						: array<CGameplayEntity>;
	var entities_col					: array<CGameplayEntity>;
	var target 							: CActor;
	var targets 						: array<CActor>;
	var damage_action					: W3DamageAction;
	var damage_value					: float;
	var effect_entity					: CEntity;
	var slow 							: SCustomEffectParams;	
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		AddTimer('check_for_targets_sword_aard_cone', 0.01, true );
	}
	
	
	timer function check_for_targets_sword_aard_cone ( dt : float, optional id : int)
	{
		FindGameplayEntitiesInCone( entities, GetWorldPosition() + GetWorldForward() * 3, VecHeading( GetWorldForward() * -1 ), 180, 4, 100 );
		if ( entities.Size() >0 )
		{
			for( i = 0; i < entities.Size(); i += 1 )
			{
				if ( !entities_col.Contains( entities[i] ) && !entities[i].HasTag('spells_custom_projs') )
				{
					entities_col.PushBack( entities[i] );
					
					target = (CActor)entities[i];
					if ( target && target != thePlayer && GetAttitudeBetween( target, thePlayer ) == AIA_Hostile && target.IsAlive() )
					{
						damage_value = get_damage_value_for_cone_far( target, GetMagicVigil().get_magic_spellpower() );
						damage_value *= get_sword_spells_dmg_mod();
						damage_value += damage_value * get_overall_mult();
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_Heavy,CPS_Undefined,false, false, true, false );
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetCanPlayHitParticle(false);
						damage_action.SetHitAnimationPlayType(EAHA_Default);
						
						damage_action.SetHitEffect('');
						damage_action.SetHitEffect('', true );
						damage_action.SetHitEffect('', false, true);
						damage_action.SetHitEffect('', true, true);
						
						if( RandF() <= 0.15)
						{	
							damage_action.AddEffectInfo( EET_KnockdownTypeApplicator, 1 );	
						}
						else
						{	
							damage_action.AddEffectInfo( EET_Stagger );	
						}
						
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_FORCE, sp_force_dmg_mod() * damage_value );
						
						effect_entity = target.CreateFXEntityAtPelvis( 'sword_ring_small_effects', true );
						effect_entity.PlayEffect( 'aard_cone_hit' );
						effect_entity.DestroyAfter(5);
						
						if ( spells_can_dismember( target ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action );
						delete damage_action;
					}
				}
			}
		}
	}
	
	event OnRangeReached()
	{
		StopProjectile();
		RemoveTimer('check_for_targets_sword_aard_cone');
	}
}


class W3MenschfeindYrd extends W3TraceGroundProjectile
{
	var action 				: W3DamageAction;
	var damage 				: float;
	var spellpower_final 	: float;
	var lastpos, pos		: Vector;
	var entities			: array<CGameplayEntity>;
	var i					: int;

	event OnSpawned( spawnData : SEntitySpawnData )
	{	
		spellpower_final = get_spellpower_spells_signs();
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( !isActive || IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;
		
		super.OnProjectileCollision(pos, normal, collidingComponent, hitCollisionsGroups, actorIndex, shapeIndex);
		
		FindGameplayEntitiesInCylinder( entities, pos, 2, 4, 99, );
		
		for( i = 0; i < entities.Size(); i += 1 )
		{
			victim = entities[i];
		
			if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer && ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile) && victim.IsAlive())
			{
				damage = get_damage_value_for_cone_far( (CActor)victim, spellpower_final );
				//theGame.witcherLog.AddMessage("damage " + damage );
				damage *= 0.35;
				damage += damage * 2 * thePlayer.GetSpecialAttackTimeRatio();
				//theGame.witcherLog.AddMessage("damage calc " + damage );

				action = new W3DamageAction in this;
				action.Initialize( thePlayer, victim, this, thePlayer.GetName(), EHRT_Heavy, CPS_Undefined, false, false, true, false);
				action.SetProcessBuffsIfNoDamage(true);
				action.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * damage );
				action.SetHitAnimationPlayType(EAHA_Default);
				
				if ( spells_can_dismember( (CActor)victim ) )
				{
					action.SetForceExplosionDismemberment();
				}
				
				theGame.damageMgr.ProcessAction( action );
				collidedEntities.PushBack(victim);
				delete action;
				
				victim.PlayEffect('yrden_shock');
			}
		}
	}
}

class W3MenschfeindAxii extends W3TraceGroundProjectile
{
	var action 				: W3DamageAction;
	var damage 				: float;
	var spellpower_final 	: float;
	var lastpos, pos		: Vector;
	var entities			: array<CGameplayEntity>;
	var i					: int;
	var effect_entity		: CEntity;

	event OnSpawned( spawnData : SEntitySpawnData )
	{	
		spellpower_final = get_spellpower_spells_signs();
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( !isActive || IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;
		
		super.OnProjectileCollision(pos, normal, collidingComponent, hitCollisionsGroups, actorIndex, shapeIndex);
		
		FindGameplayEntitiesInCylinder( entities, pos, 2, 4, 99, );
		
		for( i = 0; i < entities.Size(); i += 1 )
		{
			victim = entities[i];
		
			if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer && ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile) && victim.IsAlive())
			{
				damage = get_damage_value_for_cone_far( (CActor)victim, spellpower_final );
				//theGame.witcherLog.AddMessage("damage " + damage );
				damage *= 0.35;
				damage += damage * 2 * thePlayer.GetSpecialAttackTimeRatio();
				//theGame.witcherLog.AddMessage("damage calc " + damage );

				action = new W3DamageAction in this;
				action.Initialize( thePlayer, victim, this, thePlayer.GetName(), EHRT_Heavy, CPS_Undefined, false, false, true, false);
				action.SetProcessBuffsIfNoDamage(true);
				action.AddDamage( theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damage );
				action.SetHitAnimationPlayType(EAHA_Default);
				
				if ( spells_can_dismember( (CActor)victim ) )
				{
					action.SetForceExplosionDismemberment();
				}
				
				if( RandF() <= 0.25 )
				{
					action.AddEffectInfo( EET_Frozen, 2.5 );
				}
				else
				{
					action.AddEffectInfo( EET_SlowdownFrost, 4 );
				}
				
				theGame.damageMgr.ProcessAction( action );
				collidedEntities.PushBack(victim);
				delete action;
				
				effect_entity = ((CActor) victim).CreateFXEntityAtPelvis( 'wintersouls_effects', true );
				effect_entity.PlayEffect( 'wintersouls_flame' );
				effect_entity.DestroyAfter(5);
			}
		}
	}
}

class W3MenschfeindQuen extends W3TraceGroundProjectile
{
	var action 				: W3DamageAction;
	var damage 				: float;
	var spellpower_final 	: float;
	var lastpos, pos		: Vector;
	var entities			: array<CGameplayEntity>;
	var i					: int;
	var effect_entity		: CEntity;

	event OnSpawned( spawnData : SEntitySpawnData )
	{	
		spellpower_final = get_spellpower_spells_signs();
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( !isActive || IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;
		
		super.OnProjectileCollision(pos, normal, collidingComponent, hitCollisionsGroups, actorIndex, shapeIndex);
		
		FindGameplayEntitiesInCylinder( entities, pos, 2, 4, 99, );
		
		for( i = 0; i < entities.Size(); i += 1 )
		{
			victim = entities[i];
		
			if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer && ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile) && victim.IsAlive())
			{
				damage = get_damage_value_for_cone_far( (CActor)victim, spellpower_final );
				//theGame.witcherLog.AddMessage("damage " + damage );
				damage *= 0.35;
				damage += damage * 2 * thePlayer.GetSpecialAttackTimeRatio();
				//theGame.witcherLog.AddMessage("damage calc " + damage );

				action = new W3DamageAction in this;
				action.Initialize( thePlayer, victim, this, thePlayer.GetName(), EHRT_Heavy, CPS_Undefined, false, false, true, false);
				action.SetProcessBuffsIfNoDamage(true);
				action.AddDamage( theGame.params.DAMAGE_NAME_POISON, sp_pois_dmg_mod() * damage );
				action.SetHitAnimationPlayType(EAHA_Default);
				
				if ( spells_can_dismember( (CActor)victim ) )
				{
					action.SetForceExplosionDismemberment();
				}
				
				if ( RandF() <=0.6 )
				{
					action.AddEffectInfo( EET_Poison, 4 );
					//theGame.witcherLog.AddMessage("DURATION " + MaxF( 3, MinF( 8, spellpower_final*3 ) ) );
				}
				
				theGame.damageMgr.ProcessAction( action );
				collidedEntities.PushBack(victim);
				delete action;
			}
		}
	}
}

class W3MenschfeindAard extends W3TraceGroundProjectile
{
	var action 				: W3DamageAction;
	var damage 				: float;
	var spellpower_final 	: float;
	var lastpos, pos		: Vector;
	var entities			: array<CGameplayEntity>;
	var i					: int;
	var effect_entity		: CEntity;

	event OnSpawned( spawnData : SEntitySpawnData )
	{	
		spellpower_final = get_spellpower_spells_signs();
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( !isActive || IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;
		
		super.OnProjectileCollision(pos, normal, collidingComponent, hitCollisionsGroups, actorIndex, shapeIndex);
		
		FindGameplayEntitiesInCylinder( entities, pos, 2, 4, 99, );
		
		for( i = 0; i < entities.Size(); i += 1 )
		{
			victim = entities[i];
		
			if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer && ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile) && victim.IsAlive())
			{
				damage = get_damage_value_for_cone_far( (CActor)victim, spellpower_final );
				//theGame.witcherLog.AddMessage("damage " + damage );
				damage *= 0.35;
				damage += damage * 2 * thePlayer.GetSpecialAttackTimeRatio();
				//theGame.witcherLog.AddMessage("damage calc " + damage );

				action = new W3DamageAction in this;
				action.Initialize( thePlayer, victim, this, thePlayer.GetName(), EHRT_Heavy, CPS_Undefined, false, false, true, false);
				action.SetProcessBuffsIfNoDamage(true);
				action.AddDamage( theGame.params.DAMAGE_NAME_FORCE, sp_force_dmg_mod() * damage );
				action.SetHitAnimationPlayType(EAHA_Default);
				
				if ( spells_can_dismember( (CActor)victim ) )
				{
					action.SetForceExplosionDismemberment();
				}
				
				if( RandF() <= 0.3){ action.AddEffectInfo( EET_Bleeding, 3 ); 			}
				if( RandF() <= 0.3)
				{	action.AddEffectInfo( EET_Knockdown, 3 );							}
				else
				{	action.AddEffectInfo( EET_LongStagger  );							}
				
				effect_entity = ((CActor) victim).CreateFXEntityAtPelvis( 'sword_ring_small_effects', true );
				effect_entity.PlayEffect( 'aard_cone_hit' );
				effect_entity.DestroyAfter(5);
				
				theGame.damageMgr.ProcessAction( action );
				collidedEntities.PushBack(victim);
				delete action;
			}
		}
	}
}

class W3MenschfeindIgni extends W3TraceGroundProjectile
{
	var action 				: W3DamageAction;
	var damage 				: float;
	var spellpower_final 	: float;
	var lastpos, pos		: Vector;
	var entities			: array<CGameplayEntity>;
	var i					: int;
	var effect_entity		: CEntity;

	event OnSpawned( spawnData : SEntitySpawnData )
	{	
		spellpower_final = get_spellpower_spells_signs();
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( !isActive || IsStopped() )
		{
			return true;
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		else
			victim = NULL;
		
		super.OnProjectileCollision(pos, normal, collidingComponent, hitCollisionsGroups, actorIndex, shapeIndex);
		
		FindGameplayEntitiesInCylinder( entities, pos, 2, 4, 99, );
		
		for( i = 0; i < entities.Size(); i += 1 )
		{
			victim = entities[i];
		
			if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer && ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile) && victim.IsAlive())
			{
				damage = get_damage_value_for_cone_far( (CActor)victim, spellpower_final );
				//theGame.witcherLog.AddMessage("damage " + damage );
				damage *= 0.35;
				damage += damage * 2 * thePlayer.GetSpecialAttackTimeRatio();
				//theGame.witcherLog.AddMessage("damage calc " + damage );

				action = new W3DamageAction in this;
				action.Initialize( thePlayer, victim, this, thePlayer.GetName(), EHRT_Heavy, CPS_Undefined, false, false, true, false);
				action.SetProcessBuffsIfNoDamage(true);
				action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage  );
				action.SetHitAnimationPlayType(EAHA_Default);
				
				action.SetHitEffect('igni_cone_hit', false, false);
				action.SetHitEffect('igni_cone_hit', true, false);
				action.SetHitReactionType(EHRT_Igni, false);
				
				if ( spells_can_dismember( (CActor)victim ) )
				{
					action.SetForceExplosionDismemberment();
				}
				
				if( RandF() <= 0.2 )
				{
					action.AddEffectInfo( EET_Burning, 1.5 );
				}
				
				effect_entity = ((CActor) victim).CreateFXEntityAtPelvis( 'fire_gnosis_effects', true );
				effect_entity.PlayEffect( 'flame' );
				effect_entity.DestroyAfter(5);
				
				theGame.damageMgr.ProcessAction( action );
				collidedEntities.PushBack(victim);
				delete action;
			}
		}
	}
}

function deal_damage_bolt_yrden( pos : Vector )
{
	var entities		: array<CGameplayEntity>;
	var victimtarget	: CActor;
	var action 			: W3DamageAction;
	var damage			: float;
	var effect 			: CEntity;
	var i 				: int;
	
	FindGameplayEntitiesInSphere( entities, pos, 3.5, 100 );
	for( i = 0; i < entities.Size(); i += 1 )
	{
		victimtarget = (CActor)entities[i];
		if ( victimtarget && victimtarget != thePlayer && GetAttitudeBetween( victimtarget, thePlayer ) == AIA_Hostile && victimtarget.IsAlive() ) 
		{
			damage = get_damage_value_for_projectile( victimtarget, get_spellpower_spells( false, S_Magic_3 ) );
			damage *= get_xbow_spells_dmg_mod();
			damage += damage * get_overall_mult();
			
			action = new W3DamageAction in theGame.damageMgr;
			action.Initialize(thePlayer,victimtarget,NULL,thePlayer.GetName(),EHRT_Heavy,CPS_Undefined,false, false, true, false );
			action.SetProcessBuffsIfNoDamage(true);
			action.SetCanPlayHitParticle(false);
		
			action.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * damage );
			
			if ( spells_can_dismember( victimtarget ) )
			{
				action.SetForceExplosionDismemberment();
			}
			
			theGame.damageMgr.ProcessAction( action );
			delete action;
			
			effect = victimtarget.CreateFXEntityAtPelvis( 'sword_ring_small_effects', true );
			effect.PlayEffect( 'yrden_shock_cut' );			
			effect.DestroyAfter(5);
		}
	}
}

function deal_damage_bolt_axii( pos : Vector )
{
	var entities		: array<CGameplayEntity>;
	var victimtarget	: CActor;
	var action 			: W3DamageAction;
	var damage			: float;
	var effect 			: CEntity;
	var sloweffect 		: SCustomEffectParams;
	var i 				: int;
	
	GetMagicVigil().set_magic_spellpower( get_spellpower_spells( false, S_Magic_5 ) );
	
	FindGameplayEntitiesInSphere( entities, pos, 5, 100 );
	for( i = 0; i < entities.Size(); i += 1 )
	{
		if ( !entities[i].HasTag('spells_custom_projs') )
		{
			entities[i].OnAardHit( NULL );
		}
	
		victimtarget = (CActor)entities[i];
		if ( victimtarget && victimtarget != thePlayer && GetAttitudeBetween( victimtarget, thePlayer ) == AIA_Hostile && victimtarget.IsAlive() ) 
		{
			sloweffect.effectType = EET_SpellsSlowDownAverage;
			sloweffect.creator = thePlayer;
			sloweffect.duration = 5;
			victimtarget.AddEffectCustom(sloweffect);
		}
	}
}
